/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.StartEndQtyUpdater;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.IdentityHashSet;
import cz.insophy.inplan.util.TimeSpan;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkplaceCalendarTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WorkplaceCalendarTemplate.class);
    private final String workplaceName;
    private final long from;
    private final long to;
    private final List<TimeSpan> offlines;

    public WorkplaceCalendarTemplate(String workplaceName, long from, long to, List<TimeSpan> offlines) {
        Preconditions.checkState(offlines.isEmpty() || from <= offlines.get(0).getStart());
        Preconditions.checkState(offlines.isEmpty() || to >= offlines.get(offlines.size() - 1).getEnd());
        this.workplaceName = workplaceName;
        this.from = from;
        this.to = to;
        this.offlines = offlines;
    }

    public String getWorkplaceName() {
        return this.workplaceName;
    }

    public List<TimeSpan> getOfflines() {
        return this.offlines;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public static void applyToSuperplan(Collection<WorkplaceCalendarTemplate> templates, Superplan superplan) {
        if (templates == null) {
            throw new IllegalArgumentException("Templates must not be null.");
        }
        if (superplan == null) {
            throw new IllegalArgumentException("Superplan must not be null.");
        }
        IdentityHashSet<GeneralizedOrderRequest> affectedGors = new IdentityHashSet<GeneralizedOrderRequest>();
        for (WorkplaceCalendarTemplate wct : templates) {
            Workplace wp = superplan.getShopConf().getWorkplace(wct.getWorkplaceName());
            if (wp == null) {
                log.warn("Skipping unknown workplace {} from calendar template.", (Object)wct.getWorkplaceName());
                continue;
            }
            if (wct.getOfflines().size() == 0) {
                ProductionTreeAlgorithms.clearPlan(superplan, List.of(wp), wct.getFrom(), wct.getTo(), true, false, false, false, false, false, ProductionTreeAlgorithms.FixationLevel.NOTHING);
                WorkplaceActivity act = superplan.getPlan().getWorkplaceSchedule(wp).getActivityStartIncl(wct.getFrom());
                if (act instanceof OfflineActivity) {
                    superplan.getPlan().removeActivity(act);
                    superplan.addOffline(new OfflineActivity(act.getStart(), wct.getFrom(), wp));
                    if (act.getEnd() > wct.getTo()) {
                        superplan.addOffline(new OfflineActivity(wct.getTo(), act.getEnd(), wp));
                    }
                }
                if (!((act = superplan.getPlan().getWorkplaceSchedule(wp).getActivity(wct.getTo())) instanceof OfflineActivity)) continue;
                superplan.getPlan().removeActivity(act);
                superplan.addOffline(new OfflineActivity(wct.getTo(), act.getEnd(), wp));
                continue;
            }
            TimeSpan firstOffline = wct.getOfflines().get(0);
            TimeSpan lastOffline = wct.getOfflines().get(wct.getOfflines().size() - 1);
            ProductionTreeAlgorithms.ClearResult clearRes = ProductionTreeAlgorithms.clearPlan(superplan, List.of(wp), firstOffline.getStart(), lastOffline.getEnd(), false, true, true, true, false, false, ProductionTreeAlgorithms.FixationLevel.NOTHING);
            affectedGors.addAll(clearRes.affectedGors());
            ProductionTreeAlgorithms.clearPlan(superplan, List.of(wp), wct.getFrom(), wct.getTo(), true, false, false, false, false, false, ProductionTreeAlgorithms.FixationLevel.NOTHING);
            ArrayList<OfflineActivity> borderOfflines = Lists.newArrayListWithCapacity(2);
            WorkplaceActivity act = superplan.getPlan().getWorkplaceSchedule(wp).getActivityStartIncl(wct.getFrom());
            if (act instanceof OfflineActivity) {
                superplan.getPlan().removeActivity(act);
                if (firstOffline.getStart() == wct.getFrom()) {
                    WorkplaceCalendarTemplate.addBorderOffline(borderOfflines, act.getStart(), firstOffline.getEnd(), wp);
                } else {
                    WorkplaceCalendarTemplate.addBorderOffline(borderOfflines, act.getStart(), wct.getFrom(), wp);
                    firstOffline = null;
                }
                if (act.getEnd() > wct.getTo()) {
                    WorkplaceCalendarTemplate.addBorderOffline(borderOfflines, wct.getTo(), act.getEnd(), wp);
                }
            } else {
                firstOffline = null;
            }
            if ((act = superplan.getPlan().getWorkplaceSchedule(wp).getActivityEndIncl(wct.getTo())) instanceof OfflineActivity) {
                superplan.getPlan().removeActivity(act);
                if (lastOffline.getEnd() == wct.getTo() && !Objects.equals(firstOffline, lastOffline)) {
                    WorkplaceCalendarTemplate.addBorderOffline(borderOfflines, lastOffline.getStart(), act.getEnd(), wp);
                } else {
                    WorkplaceCalendarTemplate.addBorderOffline(borderOfflines, wct.getTo(), act.getEnd(), wp);
                    lastOffline = null;
                }
            } else {
                lastOffline = null;
            }
            for (TimeSpan span : wct.offlines) {
                if (Objects.equals(span, firstOffline) || Objects.equals(span, lastOffline)) continue;
                superplan.addOffline(new OfflineActivity(span.getStart(), span.getEnd(), wp));
            }
            for (OfflineActivity oa : borderOfflines) {
                superplan.addOffline(oa);
            }
            WorkplaceCalendarTemplate.possiblyJoinOfflines(superplan, wp, wct.from);
            WorkplaceCalendarTemplate.possiblyJoinOfflines(superplan, wp, wct.to);
        }
        affectedGors.forEach(StartEndQtyUpdater::updateFrom);
    }

    private static void addBorderOffline(List<OfflineActivity> borderOfflines, long start, long end, Workplace wp) {
        if (start < end) {
            borderOfflines.add(new OfflineActivity(start, end, wp));
        }
    }

    private static void possiblyJoinOfflines(Superplan superplan, Workplace wp, long at) {
        WorkplaceActivity right;
        WorkplaceSchedule wps = superplan.getPlan().getWorkplaceSchedule(wp);
        WorkplaceActivity left = wps.getActivityEndIncl(at);
        if (left != (right = wps.getActivityStartIncl(at)) && left instanceof OfflineActivity && right instanceof OfflineActivity) {
            superplan.getPlan().removeActivity(left);
            superplan.getPlan().removeActivity(right);
            superplan.addOffline(new OfflineActivity(left.getStart(), right.getEnd(), wp));
        }
    }
}

